#version 330
#extension GL_EXT_gpu_shader4 : enable
// Procedural LandscapeMod01.fsh  by   Rosie
//https://www.shadertoy.com/view/4tlSDS
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float cosNoise(in vec2 pos){
	return 0.5*(sin(pos.x) + sin(pos.y));
}

const mat2 m2 = mat2(0.8, -0.6,
                     0.6, 0.8); 

float map(in vec3 pos){
//	circle return length(pos - vec3(0.0,0.0,-2.0)) -1.0;
    vec2 q = pos.xz * 0.5;
    float h = 0.0;
        
    float s = 0.5;
    for(int i = 0; i<10; i++){
   	   h += s*cosNoise(q);
       s *= 0.5;
       q = m2 * q * 1.7;
    }
    
    h *= 3.0;
  
    return pos.y - h;
}




vec3 calcNormal(in vec3 pos){
	vec3 nor;
    vec2 e = vec2(0.01,0.0);
    nor.x = map(pos + e.xyy) - map(pos - e.xyy);
    nor.y = map(pos + e.yxy) - map(pos - e.yxy);
    nor.z = map(pos + e.yyx) - map(pos - e.yyx);
    return normalize(nor);
}

float calcShadow(in vec3 ro, in vec3 rd){
    float res = 1.0;
    float t = 0.1;
    for (int i = 0; i <64; i++){
    	vec3 pos = ro + t*rd;
        float h = map(pos);
       res = min( res, max(h,0.0)*164.0/t );
        if(res< 0.0001) break;
        t+=h*0.5;
    }
    return res;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 p = gl_FragCoord.xy / iResolution.xy;
    vec2 q = -1.0 + 2.0*p;
    q.x *= 1.777; 
    
    vec3 ro = vec3(0.0, 1.65, -iTime);
    vec3 rd = normalize( vec3(q, -1.0));
    
    vec3 col = vec3(0.7, 0.8, 1.0);
    col *= 1.0 -0.5 *rd.y;
    float tmax =40.0;
    float t = 0.0;
    
    for(int i=0; i<256; i++){
    	vec3 pos = ro + rd*t;
        float h = map(pos);
        if(h < 0.001 || t > tmax) break;
        
        t += h*0.5;
    }
    
    vec3 light = normalize(vec3(1.0,0.1,-0.5));
    
    if(t < tmax){
        vec3 pos = ro + t*rd;
        vec3 nor = calcNormal(pos);
        float sha = calcShadow(pos + nor *0.1,light);

        float dif = clamp (dot(nor,light), 0.0,1.0);
        vec3 lig = vec3(2.0, 1.5,1.0)*dif *sha;
        lig += vec3(0.1,0.2,0.3)*nor.y *2.0;
        
        
        vec3 mate = vec3(0.2, 0.3, 0.3)*0.5; 
        mate = mix(mate, vec3(0.2,0.15,0.1), smoothstep(0.7,0.9,nor.y));
    	col = lig * mate;
        
        float fog = exp(-0.002 *t * t);
        col *= fog;
        col += ((1.0 - fog)*vec3(0.5,0.6,0.7));
    }
    
    // gamut for monitor
    col = sqrt(col);
    
	gl_FragColor = vec4(col,1.0);
}
